unit [!UnitName];

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
[!if=(EcoSpaceUnitName, "<NONE>")]
  Borland.Eco.Handles;
[!else]
  Borland.Eco.Handles, [!EcoSpaceUnitName], [!EcoPackageUnitName];
[!endif]

type
  T[!ClassName] = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    fEcoSpace: [!EcoSpaceClassName];
    function get_EcoSpace: [!EcoSpaceClassName];
    property EcoSpace: [!EcoSpaceClassName] read get_EcoSpace;
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
    procedure Page_Unload(sender: System.Object; e: System.EventArgs);
  strict protected
    procedure OnInit(e: EventArgs); override;
  public
    procedure DataBind; override;
  end;

implementation

uses
  Borland.Eco.ObjectRepresentation, Borland.Eco.Services;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure T[!ClassName].InitializeComponent;
begin    
  Include(Self.Load, Self.Page_Load);
  Include(Self.Unload, Self.Page_Unload);
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  //
  // rhRoot
  //
  Self.rhRoot.EcoSpace := nil;
[!if=(EcoSpaceUnitName, "<NONE>")]
[!else]
  Self.rhRoot.EcoSpaceType := TypeOf([!EcoSpaceUnitName].[!EcoSpaceClassName]);
[!endif]
  Self.rhRoot.StaticValueTypeName := '';
  Self.rhRoot.Variables := nil;
end;
{$ENDREGION}

procedure T[!ClassName].Page_Load(sender: System.Object; e: System.EventArgs);
begin
  EcoSpace.Active := True;
  // TODO: Put user code to initialize the page here
end;

procedure T[!ClassName].Page_Unload(sender: System.Object; e: System.EventArgs);
begin
  EcoSpace.Active := False;
end;

procedure T[!ClassName].DataBind;
begin
  ElementHandle.EnsureAllBindingLists;
  inherited DataBind;
end;

procedure T[!ClassName].OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

function T[!ClassName].get_EcoSpace: [!EcoSpaceClassName];
begin
[!if=(EcoSpaceUnitName, "<NONE>")]
[!else]
  if not Assigned(fEcoSpace) then
  begin
    fEcoSpace := [!EcoSpaceClassName].Create;
    rhRoot.EcoSpace := fEcoSpace;
  end;
[!endif]
  result := fEcoSpace;
end;

end.

